/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.ddl;

import org.h14199.command.ddl.DefineCommand;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.engine.UserAggregate;
import org.h14199.message.DbException;
import org.h14199.schema.Schema;

public class CreateAggregate
extends DefineCommand {
    private Schema schema;
    private String name;
    private String javaClassMethod;
    private boolean ifNotExists;
    private boolean force;

    public CreateAggregate(Session session) {
        super(session);
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (database.findAggregate(this.name) != null || this.schema.findFunction(this.name) != null) {
            if (!this.ifNotExists) {
                throw DbException.get(90076, this.name);
            }
        } else {
            int n = this.getObjectId();
            UserAggregate userAggregate = new UserAggregate(database, n, this.name, this.javaClassMethod, this.force);
            database.addDatabaseObject(this.session, userAggregate);
        }
        return 0;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    @Override
    public int getType() {
        return 22;
    }
}

